// Background service worker
// Minimal background script for extension management

console.log('[Immerse] Background service worker started');

// Listen for extension installation
chrome.runtime.onInstalled.addListener((details) => {
  console.log('[Immerse] Extension installed/updated:', details.reason);
  console.log('[Immerse] Background service worker initialized');
});

// Listen for messages from content scripts (for future functionality)
chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
  console.log('[Immerse] Message received in background:', message);

  sendResponse({ status: 'received' });
  return true;
});

// Log when activated
chrome.action.onClicked.addListener((tab) => {
  console.log('[Immerse] Extension icon clicked for tab:', tab.id);
});

console.log('[Immerse] Background script setup complete');
