// Background service worker - handles coordination only
// NOTE: Chrome Built-in AI API is NOT available in service workers
// All AI calls must happen in content scripts (page context)

chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
  if (message.type === 'CHECK_API_AVAILABILITY') {
    // We can't check from here - tell popup to check via content script
    sendResponse({ 
      checkInContentScript: true,
      message: 'API must be checked from page context'
    });
    return true;
  }
  
  if (message.type === 'API_STATUS_FROM_CONTENT') {
    // Content script is reporting API status
    console.log('API Status from content script:', message.status);
    sendResponse({ received: true });
    return true;
  }

  if (message.type === 'START_TRANSLATION') {
    // Forward to content script
    chrome.tabs.query({ active: true, currentWindow: true }, (tabs) => {
      if (tabs[0]) {
        chrome.tabs.sendMessage(tabs[0].id, { type: 'START_TRANSLATION' })
          .then(() => sendResponse({ success: true }))
          .catch(err => sendResponse({ success: false, error: err.message }));
      }
    });
    return true;
  }
});

// Log that background script is loaded
console.log('Immerse background script loaded');
console.log('NOTE: AI API calls happen in content scripts, not here');
