const SKIP = 'script,style,noscript,svg,input,textarea,code,pre,nav,footer';

function replace_tag_text(tagText, elems) {
  let tagID = '';
  for (const char of tagText.slice(1)) {
    if (char == ']') {
      break;}
    tagID += char;}
  elems[tagID].node.textContent = tagText.slice(tagID.length+2);
}

function format_page_text(elems=0) {
  const scan_start = performance.now();
  if (elems == 0) {
    elems = scan()
  }
  const scan_end = performance.now();
  console.log(scan_end-scan_start);
  const combinedElems = []

  for (let i = 0; i < elems.length; i++) {
    let elemText = elems[i].text || ''; // if text content for this element is falsy, we append '' to avoid error (idk when this would happen)
    combinedElems.push(`[${i}]${elemText}`);
    }
  const page_text = combinedElems.join('')
  return { page_text, elems };
}

function generate_user_specific_prompt(accountInfo) {
  // accountInfo structure from backend API (/api/login or /api/user/:id):
  // {
  //   id: number,
  //   username: string,
  //   email: string,
  //   current_level: string (A0, A1, A2, B1, B2, C1, C2),
  //   target_language: string,
  //   vocabulary_count: number,
  //   completed_skills: array of skill IDs
  // }

  if (!accountInfo) {
    return ''; // no user data available, in future we might let this work and just have no personalization?
  }

  const {
    current_level = 'A0',
    target_language = 'Spanish',
    vocabulary_count = 0,
    completed_skills = []
  } = accountInfo;

  // Build prompt based on actual user data
  let prompt = `Translate the following content to ${target_language}.\n\n`;

  prompt += `User Profile:\n`;
  prompt += `- CEFR Level: ${current_level}\n`;
  prompt += `- Known Vocabulary: ${vocabulary_count} words\n`;
  prompt += `- Completed Skills: ${completed_skills.length} skill${completed_skills.length !== 1 ? 's' : ''}\n\n`;

  // Add level-appropriate instructions
  const levelDescriptions = {
    'A0': 'complete beginner - use very basic vocabulary and simple present tense',
    'A1': 'beginner - use simple vocabulary and basic sentence structures',
    'A2': 'elementary - use common vocabulary and simple past/future tenses',
    'B1': 'intermediate - use everyday vocabulary with some complex structures',
    'B2': 'upper intermediate - use varied vocabulary with complex grammar',
    'C1': 'advanced - use sophisticated vocabulary and nuanced expressions',
    'C2': 'mastery - use native-level vocabulary and complex idiomatic expressions'
  };

  const levelDesc = levelDescriptions[current_level] || levelDescriptions['A0'];

  prompt += `Translation Instructions:\n`;
  prompt += `- User is at ${current_level} level: ${levelDesc}\n`;
  prompt += `- Keep vocabulary complexity appropriate for their ${vocabulary_count}-word vocabulary\n`;
  prompt += `- Use grammar structures suitable for ${current_level} proficiency\n`;
  prompt += `- CRITICAL: Preserve all [ID] tags in exact format (e.g., [0], [1], [2])\n`;
  prompt += `- Return ONLY the translated text with tags, no explanations or additional commentary\n\n`;

  prompt += `Content to translate:\n`;

  return prompt;
}

async function translate_loaded() {
  try {
    let tags_post_translation = [];
    let buffer = '';
    const { page_text, elems } = format_page_text();
    const elems_control_for_dynamic = [...elems];
    const pageUrl = window.location.href;
    const user_prompt = await generate_user_specific_prompt(getUserData());
    //console.log('FULL_LLM_PROMPT: \n' + user_prompt + pageUrl + page_text);
    const result = await gpt(
      page_text,
      'prompts/translate-spanish.txt', (pageUrl + user_prompt),
      (chunk) => {
        //console.log('[Immerse] Chunk received:', chunk); // implemented such that we optionally provide action to execute on chunk (eventually update elems)
        buffer += chunk;
        const matches = buffer.match(/\[\d+\]/g);
        if (matches && matches.length >= 2) {
          const secondTagIndex = buffer.indexOf(matches[1]);
          const tagText = buffer.substring(0, secondTagIndex);
          buffer = buffer.substring(secondTagIndex);
          tags_post_translation.push(tagText); // adding the tag to list of all tags so we can compare expected tag translation on page before translation versus when accounting for dynamic page changes that occur during translation
          replace_tag_text(tagText, elems);
          replace_tag_text(tagText, elems_control_for_dynamic); 
        } // plan: repalce element text in the dumby copy, then make a diff between those element texts (full accumulated string) and actual. if diff exceeds threshold, then rerun translation. 
      }
    );
    //console.log('FULL_LLM_OUTPUT: \n' + result);
    //console.log('[Immerse] Full translation:', result);
    elems_after_translation = scan();
    translate_again = analyze_pageside_changes(elems_control_for_dynamic, elems_after_translation);
    console.log('translate again??: ' + translate_again);
    console.log("after length: " + elems_after_translation.length);
    console.log("expected after length: " + elems_control_for_dynamic.length);
    return translate_again; // returning the expected page tags after translation, not registering dynamic updates pageside
  } catch (error) {
    console.error('[Immerse] Translation test failed:', error.message);
  }
}

// Also support module exports for testing
if (typeof module !== 'undefined' && module.exports) {
  module.exports = { scan, replace_tag_text, format_page_text, translate_loaded };
}