interface Segment {
    id: number;
    el: Element;
    text: string;
  }
  
  const SKIP = 'script,style,noscript,svg,input,textarea,code,pre,nav,footer';
  
  function scan(root: Element = document.body): Segment[] {
    const segments: Segment[] = [];
    const walker = document.createTreeWalker(root, NodeFilter.SHOW_TEXT);
    let node: Text | null, id = 0;
  
    while ((node = walker.nextNode() as Text)) {
      const text = node.textContent?.trim();
      const parent = node.parentElement;
      if (!text || text.length < 10 || !parent || parent.closest(SKIP)) continue;
  
      parent.dataset.txId = String(id);
      segments.push({ id: id++, el: parent, text });
    }
    return segments;
  }
  
  // Run
  const results = scan();
  results.forEach(s => console.log(`[${s.id}] ${s.el.tagName}: ${s.text.slice(0, 60)}`));